VERSION 5.00
Object = "{A73F35A4-856E-11D2-B689-0080C74142B7}#1.0#0"; "RENDER6DXAXXCONTROL1.OCX"
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Begin VB.Form frmMain 
   BackColor       =   &H80000004&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Dungeon Chat 6DX - Beta 2"
   ClientHeight    =   4065
   ClientLeft      =   45
   ClientTop       =   300
   ClientWidth     =   7575
   FillColor       =   &H8000000F&
   ForeColor       =   &H8000000F&
   Icon            =   "frmMain.frx":0000
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   271
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   505
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame3 
      Caption         =   "Instructions"
      Height          =   3975
      Left            =   4800
      TabIndex        =   19
      Top             =   0
      Width           =   2655
      Begin VB.TextBox txtInfo 
         Appearance      =   0  'Flat
         BackColor       =   &H80000004&
         BorderStyle     =   0  'None
         Height          =   3135
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   20
         Text            =   "frmMain.frx":030A
         Top             =   720
         Width           =   2415
      End
      Begin VB.Label Label6 
         Caption         =   "Don't select ""Windowed Mode""!"
         ForeColor       =   &H000000FF&
         Height          =   255
         Left            =   120
         TabIndex        =   21
         Top             =   360
         Width           =   2415
      End
   End
   Begin VB.CommandButton cmdEnterChat 
      Caption         =   "Enter Chat"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2400
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   3600
      Width           =   2295
   End
   Begin VB.CommandButton cmdConnect 
      Caption         =   "Connect and Initialise"
      Height          =   375
      Left            =   120
      TabIndex        =   15
      TabStop         =   0   'False
      Top             =   3600
      Width           =   2295
   End
   Begin VB.Frame Frame2 
      Caption         =   "Network Options"
      Height          =   1335
      Left            =   120
      TabIndex        =   7
      Top             =   2160
      Width           =   4575
      Begin VB.TextBox txtAddress 
         Height          =   285
         Left            =   3480
         TabIndex        =   9
         TabStop         =   0   'False
         Text            =   "127.0.0.1"
         Top             =   240
         Width           =   975
      End
      Begin VB.TextBox txtTimer 
         Height          =   285
         Left            =   3480
         TabIndex        =   8
         TabStop         =   0   'False
         Text            =   "200"
         Top             =   600
         Width           =   975
      End
      Begin VB.Label Label1 
         Alignment       =   1  'Right Justify
         BackColor       =   &H80000004&
         Caption         =   "Partner's IP Address:"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   1080
         TabIndex        =   11
         Top             =   240
         Width           =   2295
      End
      Begin VB.Label Label4 
         Alignment       =   1  'Right Justify
         BackColor       =   &H80000004&
         Caption         =   "Position update frequency (ms):"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   480
         TabIndex        =   10
         Top             =   600
         Width           =   2895
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "3D Engine Options"
      Height          =   2055
      Left            =   120
      TabIndex        =   0
      Top             =   0
      Width           =   4575
      Begin VB.ListBox lstEngineInfo 
         Height          =   1425
         Left            =   1920
         TabIndex        =   17
         Top             =   480
         Width           =   2535
      End
      Begin VB.CheckBox Check1 
         BackColor       =   &H80000004&
         Caption         =   "Bilinear Filtering"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   120
         TabIndex        =   6
         TabStop         =   0   'False
         Top             =   480
         Value           =   1  'Checked
         Width           =   1455
      End
      Begin VB.CheckBox Check3 
         BackColor       =   &H80000004&
         Caption         =   "Fogging"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   120
         TabIndex        =   5
         TabStop         =   0   'False
         Top             =   720
         Value           =   1  'Checked
         Width           =   1455
      End
      Begin VB.CheckBox Check4 
         BackColor       =   &H80000004&
         Caption         =   "Lightmaps"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   120
         TabIndex        =   4
         TabStop         =   0   'False
         Top             =   960
         Value           =   1  'Checked
         Width           =   1455
      End
      Begin VB.CheckBox Check5 
         BackColor       =   &H80000004&
         Caption         =   "Low -Res Mips"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   120
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   1200
         Width           =   1455
      End
      Begin VB.CheckBox Check2 
         BackColor       =   &H80000004&
         Caption         =   "Bobbing"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   120
         TabIndex        =   2
         TabStop         =   0   'False
         Top             =   1440
         Width           =   1455
      End
      Begin VB.CheckBox Check6 
         BackColor       =   &H80000004&
         Caption         =   "Show Weapon"
         ForeColor       =   &H00000000&
         Height          =   255
         Left            =   120
         TabIndex        =   1
         TabStop         =   0   'False
         Top             =   1680
         Width           =   1455
      End
      Begin VB.Label Label5 
         Alignment       =   1  'Right Justify
         Caption         =   "Engine info"
         Height          =   255
         Left            =   3000
         TabIndex        =   18
         Top             =   240
         Width           =   1455
      End
   End
   Begin VB.Timer timAutoupdate 
      Enabled         =   0   'False
      Interval        =   250
      Left            =   360
      Top             =   3720
   End
   Begin MSWinsockLib.Winsock Winsock1 
      Left            =   960
      Top             =   3720
      _ExtentX        =   741
      _ExtentY        =   741
   End
   Begin VB.TextBox txtOut 
      Enabled         =   0   'False
      Height          =   285
      Left            =   3720
      ScrollBars      =   2  'Vertical
      TabIndex        =   13
      TabStop         =   0   'False
      Top             =   3720
      Visible         =   0   'False
      Width           =   615
   End
   Begin VB.TextBox txtIn 
      Enabled         =   0   'False
      Height          =   285
      Left            =   1560
      ScrollBars      =   2  'Vertical
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   3720
      Visible         =   0   'False
      Width           =   615
   End
   Begin Render6DXAXXControl1.Render6DXAXX R6dx 
      Height          =   495
      Left            =   2760
      TabIndex        =   12
      TabStop         =   0   'False
      Top             =   3600
      Visible         =   0   'False
      Width           =   1215
      AutoPaint       =   -1  'True
      Map             =   ""
      Object.Visible         =   -1  'True
      look_up         =   0   'False
      look_down       =   0   'False
      spin_left       =   0   'False
      spin_right      =   0   'False
      speed_multiplier=   1.2
      move_forward    =   0   'False
      move_backward   =   0   'False
      jump_up         =   0   'False
      activate_weapon =   0   'False
      strafe_left     =   0   'False
      strafe_right    =   0   'False
      eyeheight       =   28
      skycam          =   -1  'True
      Fog             =   -1  'True
      Fogcolor        =   0
      SoftwareMode    =   0   'False
      Softwaredoubled =   0   'False
      Bobbing         =   -1  'True
      SoftwareMouse   =   0   'False
      showweapon      =   0   'False
      Lightmaps       =   -1  'True
      Bilinearfilter  =   -1  'True
      LowresMips      =   0   'False
      DoubleBuffered  =   0   'False
      Enabled         =   -1  'True
      BiDiMode        =   0
      Cursor          =   0
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' 6DX Dungeon Chat Beta 2
' Iain C (March 99)
' Uses UDP comms implementation from the original 4DX version by David M
'
' Now with full-screen chat!
'
' Still to do:
'   Actor animation
'   Custom actors; partner will be downloaded from partner's machine
'
' Comments? Iain@rising.force9.net

Private Declare Function GetAsyncKeyState Lib "User32" (ByVal keynum As Long) As Long
Private Declare Sub RtlMoveMemory Lib "kernel32" (ByVal hpvDest As Any, ByVal hpvSource As Any, ByVal nBytes As Long)
Private Declare Function TextOut Lib "gdi32" Alias "TextOutA" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal lpString As String, ByVal nCount As Long) As Long
Private Declare Function SetBkMode Lib "gdi32" (ByVal hdc As Long, ByVal nBkMode As Long) As Long
Private Declare Function SetTextColor Lib "gdi32" (ByVal hdc As Long, ByVal crColor As Long) As Long

Private movePartner As Boolean                   ' flag to signify partner move needed
Private partner As Long                          ' handle on our partner
Private partnerX, partnerY, partnerZ As Single   ' partner's co-ords
Private partnerAngle As Long
Private camera As Camera_t                       ' an instance of camera type to work with
Dim pcc As Long                                  ' our actual camera
Private ourX, ourY, ourZ As Single               ' our co-ords
Private ourAngle As Long


Private Sub Check1_Click()
    R6dx.Bilinearfilter = (Check1.Value = 1)
End Sub

Private Sub Check2_Click()
    R6dx.Bobbing = (Check2.Value = 1)
End Sub

Private Sub Check3_Click()
    R6dx.Fog = (Check3.Value = 1)
End Sub

Private Sub Check4_Click()
    R6dx.Lightmaps = (Check4.Value = 1)
End Sub

Private Sub Check5_Click()
    R6dx.LowresMips = (Check5.Value = 1)
End Sub

Private Sub Check6_Click()
    R6dx.showweapon = (Check6.Value = 1)
End Sub

Private Sub cmdConnect_Click()

    movePartner = False
    cmdConnect.Enabled = False
    cmdEnterChat.Enabled = True
    
    R6dx.InitializeRenderer frmMain.hWnd
    lstEngineInfo.AddItem ("** Engine initialised")
    
    partner = R6dx.Actor_Add(App.Path + "\progs\Sexdroid.mdl", 10, 0, -60, 45)  ' load the partner actor: in future it'll be downloaded from the other machine!
    lstEngineInfo.AddItem ("** Partner actor added")
    
    Winsock1.Protocol = sckUDPProtocol
    Winsock1.RemoteHost = txtAddress.Text
    Winsock1.RemotePort = 2000
    Winsock1.Bind 2000
    lstEngineInfo.AddItem ("** Bound port")
    
    timAutoupdate.Enabled = True
    lstEngineInfo.AddItem ("** Begun auto transmission")
    
    ' Ensure all options are noticed before rendering (had to include this cos I keep changing the defaults in design mode)
    Check1_Click
    Check2_Click
    Check3_Click
    Check4_Click
    Check5_Click
    Check6_Click
    
    R6dx.AutoRender
    lstEngineInfo.AddItem ("** Rendering: Waiting for drop-in")

End Sub

Private Sub cmdEnterChat_Click()

    ' Disable everything so the keys don't press anything they shouldn't while in full-screen mode
    Check1.Enabled = False
    Check2.Enabled = False
    Check3.Enabled = False
    Check4.Enabled = False
    Check5.Enabled = False
    Check6.Enabled = False
    cmdEnterChat.Enabled = False
    txtAddress.Enabled = False
    txtTimer.Enabled = False
    lstEngineInfo.Enabled = False
    txtInfo.Enabled = False
    
    lstEngineInfo.AddItem ("** Dropping in")
    R6dx.ChangeDevice
    
End Sub

Private Sub Form_KeyPress(KeyAscii As Integer)
    If (cmdEnterChat.Enabled = False) And (cmdConnect.Enabled = False) Then ' We must be in the chat, process keys
        If (GetAsyncKeyState(vbKeyReturn) <> 0) Then
            ' Clear txtOut
            txtOut.Text = ""
            Exit Sub
        End If
        If (GetAsyncKeyState(vbKeyBack) <> 0) Then
            ' Delete a character from txtOut
            If Len(txtOut.Text) > 0 Then
                txtOut.SelStart = 0
                txtOut.SelLength = Len(txtOut.Text) - 1
                txtOut.Text = txtOut.SelText
                Exit Sub
            End If
        End If
        If (GetAsyncKeyState(vbKeyNumpad5) <> 0) Then
            ' Change device
            R6dx.ChangeDevice
            Exit Sub
        End If
        If (GetAsyncKeyState(vbKeyEscape) <> 0) Then
            ' Exit proggy
            End
            Exit Sub
        End If
        ' Must be part of message, add it to txtOut
        txtOut.Text = txtOut.Text + String(1, KeyAscii)
    End If
End Sub

Private Sub Form_Resize()
    Me.Width = 7665
    Me.Height = 4440
End Sub

Private Sub Form_Unload(Cancel As Integer)
    R6dx.StopRender
    timAutoupdate.Enabled = False
    Winsock1.Close
End Sub

Private Sub R6dx_OnAfterAuto(ByVal ticks As Long)

    R6dx.StopRender
        
    ' Overlay text.
    l = R6dx.GetBackbufferDC
    SetTextColor l, RGB(0, 255, 0)                             ' Green text for outgoing messages.
    SetBkMode l, 1                                             ' Transparent background.
    TextOut l, 8, 15, txtOut.Text, Len(txtOut.Text)
    SetTextColor l, RGB(255, 0, 0)                             ' Red text for incoming messages.
    SetBkMode l, 1                                             ' Transparent background.
    TextOut l, 8, 30, txtIn.Text, Len(txtIn.Text)
    R6dx.ReleaseBackbufferDC
    
    If cmdConnect.Enabled = False Then R6dx.AutoRender         ' With no check these events keep the engine rendering even when we've called .stoprender
    
End Sub

Private Sub R6dx_OnBeforeAuto(ByVal ticks As Long)
    
    ' Check movement keys
    R6dx.move_forward = (GetAsyncKeyState(38) <> 0)
    R6dx.move_backward = (GetAsyncKeyState(40) <> 0)
    R6dx.spin_left = (GetAsyncKeyState(37) <> 0)
    R6dx.spin_right = (GetAsyncKeyState(39) <> 0)
    R6dx.look_up = (GetAsyncKeyState(vbKeyPageUp) <> 0)
    R6dx.look_down = (GetAsyncKeyState(vbKeyPageDown) <> 0)
    R6dx.strafe_left = (GetAsyncKeyState(vbKeyNumpad1) <> 0)
    R6dx.strafe_right = (GetAsyncKeyState(vbKeyNumpad3) <> 0)
    R6dx.jump_up = (GetAsyncKeyState(vbKeyNumpad0) <> 0)
     
    ' Move our partner, if required
    If (movePartner) Then
        R6dx.Actor_position partner, partnerX, partnerY, partnerZ
        R6dx.Actor_Faceangle partner, partnerAngle
        movePartner = False
    End If
    
    ' Update the camera
    R6dx.UpdateCamera
    
End Sub

Private Sub R6dx_OnEngineInfo(ByVal msg As String)
    lstEngineInfo.AddItem (msg)
End Sub

Private Sub timAutoupdate_Timer()
    pcc = R6dx.GetCamera
    RtlMoveMemory VarPtr(camera), pcc, Len(camera)
    ourX = camera.location.X
    ourY = camera.location.Y
    ourZ = camera.location.z
    ourAngle = camera.angle.yaw - 90 ' Offset
    Winsock1.SendData (Chr(254) & "*N/A*" & Chr(250) & Right("00000" & Trim(Str(txtOut.SelStart)), 5) & Chr(42) & Str(ourX) & Chr(42) & Str(ourY) & Chr(42) & Str(ourZ) & Chr(42) & Str(ourAngle) & Chr(42) & Chr(255))
End Sub

Private Sub txtOut_Change()
    pcc = R6dx.GetCamera
    RtlMoveMemory VarPtr(camera), pcc, Len(camera)
    ourX = camera.location.X
    ourY = camera.location.Y
    ourAngle = camera.angle.yaw - 90 ' Offset
    Winsock1.SendData (Chr(254) & txtOut.Text & Chr(250) & Right("00000" & Trim(Str(txtOut.SelStart)), 5) & Chr(42) & Str(ourX) & Chr(42) & Str(ourY) & Chr(42) & Str(ourZ) & Chr(42) & Str(ourAngle) & Chr(42) & Chr(255))
End Sub

Private Sub txtOut_KeyPress(KeyAscii As Integer)
    If (GetAsyncKeyState(vbKeyReturn) <> 0) Then txtOut.Text = ""
End Sub

Private Sub txtTimer_Change()
    timAutoupdate.Interval = Val(txtTimer.Text & "")
End Sub

Private Sub Winsock1_DataArrival(ByVal bytesTotal As Long)
  Dim Packet As String
  Static bigpack As String
  '*** Comment from original 4dx version: ***
  'the packets stream so we use start
  'and end markers 254 & 250 & 255.
  'After the end marker I give the
  'cursor location to sync in case
  'someone is moving about

  Winsock1.GetData Packet
  If Len(Packet) = 0 Then
    Exit Sub
  End If
  bigpack = bigpack & Packet
  Do
    nstart = InStr(bigpack, Chr(254))
    nmid = InStr(bigpack, Chr(250))
    nend = InStr(Mid(bigpack, nstart), Chr(255))
    If nend > nstart Then
      stuff = Mid(bigpack, nstart + 1, nmid - nstart - 1)
      nlok = Val(Mid(bigpack, nmid + 1, 5))
      
      stemp = Mid(bigpack, nmid + 7)
      nstar = InStr(stemp, "*") 'chr(42)
      partnerX = Val(Mid(stemp, 1, nstar - 1))
      
      stemp = Mid(stemp, nstar + 1)
      nstar = InStr(stemp, "*") 'chr(42)
      partnerY = Val(Mid(stemp, 1, nstar - 1))
      
      stemp = Mid(stemp, nstar + 1)
      nstar = InStr(stemp, "*") 'chr(42)
      partnerZ = Val(Mid(stemp, 1, nstar - 1))
      
      stemp = Mid(stemp, nstar + 1)
      nstar = InStr(stemp, "*") 'chr(42)
      partnerAngle = Val(Mid(stemp, 1, nstar - 1))
      
      movePartner = True ' Signify 6dx_onBeforeAuto to update partner

      bigpack = Mid(bigpack, nend + 1)
    Else
      Exit Do
    End If
  Loop While bigpack <> ""
  If stuff <> "*N/A*" Then
    txtIn.Text = stuff
    txtIn.SelStart = nlok
  End If
End Sub
